/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.spruceui.resources;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.OptionalInt;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public interface GuiSpriteScaling {
    public static final Codec<GuiSpriteScaling> CODEC = Type.CODEC.dispatch(GuiSpriteScaling::type, type -> type.codec().codec());
    public static final GuiSpriteScaling DEFAULT = new Stretch();

    public Type type();

    @Environment(value=EnvType.CLIENT)
    public static enum Type implements class_3542
    {
        STRETCH("stretch", Stretch.CODEC),
        TILE("tile", Tile.CODEC),
        NINE_SLICE("nine_slice", NineSlice.CODEC);

        public static final Codec<Type> CODEC;
        private final String key;
        private final MapCodec<? extends GuiSpriteScaling> codec;

        private Type(String key, MapCodec<? extends GuiSpriteScaling> codec) {
            this.key = key;
            this.codec = codec;
        }

        @NotNull
        public String method_15434() {
            return this.key;
        }

        public MapCodec<? extends GuiSpriteScaling> codec() {
            return this.codec;
        }

        static {
            CODEC = class_3542.method_28140(Type::values);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Stretch() implements GuiSpriteScaling
    {
        public static final MapCodec<Stretch> CODEC = MapCodec.unit(Stretch::new);

        @Override
        public Type type() {
            return Type.STRETCH;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record Tile(int width, int height) implements GuiSpriteScaling
    {
        public static final MapCodec<Tile> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33442.fieldOf("width").forGetter(Tile::width), (App)class_5699.field_33442.fieldOf("height").forGetter(Tile::height)).apply((Applicative)instance, Tile::new));

        @Override
        public Type type() {
            return Type.TILE;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public record NineSlice(int width, int height, Border border, boolean stretchInner) implements GuiSpriteScaling
    {
        public static final MapCodec<NineSlice> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33442.fieldOf("width").forGetter(NineSlice::width), (App)class_5699.field_33442.fieldOf("height").forGetter(NineSlice::height), (App)Border.CODEC.fieldOf("border").forGetter(NineSlice::border), (App)Codec.BOOL.optionalFieldOf("stretch_inner", (Object)false).forGetter(NineSlice::stretchInner)).apply((Applicative)instance, NineSlice::new)).flatXmap(NineSlice::validate, NineSlice::validate);

        private static DataResult<NineSlice> validate(NineSlice nineSlice) {
            Border border = nineSlice.border();
            if (border.left() + border.right() >= nineSlice.width()) {
                return DataResult.error(() -> "Nine-sliced texture has no horizontal center slice: " + border.left() + " + " + border.right() + " >= " + nineSlice.width());
            }
            return border.top() + border.bottom() >= nineSlice.height() ? DataResult.error(() -> "Nine-sliced texture has no vertical center slice: " + border.top() + " + " + border.bottom() + " >= " + nineSlice.height()) : DataResult.success((Object)nineSlice);
        }

        @Override
        public Type type() {
            return Type.NINE_SLICE;
        }

        @Environment(value=EnvType.CLIENT)
        public record Border(int left, int top, int right, int bottom) {
            private static final Codec<Border> VALUE_CODEC = class_5699.field_33442.flatComapMap(integer -> new Border((int)integer, (int)integer, (int)integer, (int)integer), border -> {
                OptionalInt optionalInt = border.unpackValue();
                return optionalInt.isPresent() ? DataResult.success((Object)optionalInt.getAsInt()) : DataResult.error(() -> "Border has different side sizes");
            });
            private static final Codec<Border> RECORD_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_33441.fieldOf("left").forGetter(Border::left), (App)class_5699.field_33441.fieldOf("top").forGetter(Border::top), (App)class_5699.field_33441.fieldOf("right").forGetter(Border::right), (App)class_5699.field_33441.fieldOf("bottom").forGetter(Border::bottom)).apply((Applicative)instance, Border::new));
            static final Codec<Border> CODEC = Codec.either(VALUE_CODEC, RECORD_CODEC).xmap(either -> (Border)either.map(Function.identity(), Function.identity()), border -> border.unpackValue().isPresent() ? Either.left((Object)border) : Either.right((Object)border));

            private OptionalInt unpackValue() {
                return this.left() == this.top() && this.top() == this.right() && this.right() == this.bottom() ? OptionalInt.of(this.left()) : OptionalInt.empty();
            }
        }
    }
}

